#include <bits/stdc++.h>

using namespace std;

struct SegTree
{
    vector<int> tree;
    vector<char> prom;
    int n;
    char tp;

    void init ( int s, char typ )
    {
        tp = typ;
        n = s+10;
        tree.assign( 4*n, 0 );
        prom.assign( 4*n, 0 );
    }

    void build ( int v, int tl, int tr, string& s )
    {
        if ( tl == tr )
        {
            tree[v] = s[tl] == tp;
            return;
        }

        int mid = ( tl + tr ) / 2;

        build( 2*v, tl, mid, s );
        build( 2*v+1, mid+1, tr, s );

        tree[v] = tree[2*v] + tree[2*v+1];
    }

    void push ( int v, int tl, int tr )
    {
        if ( !prom[v] )
            return;

        tree[v] = (prom[v] == tp)*(tr-tl+1);

        if ( tl != tr )
            prom[2*v] = prom[2*v+1] = prom[v];

        prom[v] = 0;
    }

    void upd ( int v, int tl, int tr, int l, int r, char val )
    {
        push( v, tl, tr );

        if ( tr < l || r < tl )
            return;

        if ( l <= tl && tr <= r )
        {
            prom[v] = val;
            push( v, tl, tr );
            return;
        }

        int mid = ( tl + tr ) / 2;

        upd( 2*v, tl, mid, l, r, val );
        upd( 2*v+1, mid+1, tr, l, r, val );

        tree[v] = tree[2*v] + tree[2*v+1];
    }

    int get ( int v, int tl, int tr, int l, int r )
    {
        push( v, tl, tr );

        if ( tr < l || r < tl )
            return 0;

        if ( l <= tl && tr <= r )
            return tree[v];

        int mid = ( tl + tr ) / 2;

        return get( 2*v, tl, mid, l, r ) + get( 2*v+1, mid+1, tr, l, r );
    }

    int fnd ( int v, int tl, int tr, int val )
    {
        push( v, tl, tr );

        if ( tl == tr )
            return tl;

        int mid = ( tl + tr ) / 2;

        if ( get( 1, 0, n-1, 0, mid ) < val )
            return fnd( 2*v+1, mid+1, tr, val );

        return fnd( 2*v, tl, mid, val );
    }
};

int n, m;
string s;
SegTree tra, trb;

int main ()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);

    cin >> n >> m >> s;

    tra.init( n, 'a' );
    tra.init( n, 'b' );
    tra.build( 1, 0, n-1, s );
    trb.build( 1, 0, n-1, s );

    while ( m-- )
    {
        int x;
        char a, b;
        cin >> x >> a >> b;

        int pos = 0;

        if ( a == 'a' )
            pos = tra.fnd( 1, 0, n-1, x );
        else
            pos = trb.fnd( 1, 0, n-1, x );

        tra.upd( 1, 0, n-1, 0, pos, b );
            trb.upd( 1, 0, n-1, 0, pos, b );
    }

    for ( int i=0; i<n; i++ )
    {
        if ( tra.get( 1, 0, n-1, i, i ) )
            cout << 'a';
        else
            cout << 'b';
    }

    return 0;
}
